!addplugindir `${PACKAGE}\Other\Source\Plugins`

${SegmentFile}

Var Exists_LEGACY_IPFILTERDRIVER
Var Exists_Services_IPFILTERDRIVER

Var strCustomLastUpdateDate
Var strCustomCurrentDate

${Segment.OnInit}
	; Borrowed the following from PAL 2.2, Remove on release of PAL 2.2
		; Work out if it's 64-bit or 32-bit
	System::Call kernel32::GetCurrentProcess()i.s
	System::Call kernel32::IsWow64Process(is,*i.r0)
	${If} $0 == 0
		StrCpy $Bits 32
	${Else}
		StrCpy $Bits 64
	${EndIf}
!macroend

${SegmentInit}
    ${If} $Bits = 64
		${If} ${AtLeastWinVista}
			${SetEnvironmentVariablesPath} CustomFullPath "$EXEDIR\App\PeerBlock\Modern64"
		${Else}
			${SetEnvironmentVariablesPath} CustomFullPath "$EXEDIR\App\PeerBlock\Legacy64"
		${EndIf}
    ${Else}
		${If} ${AtLeastWinVista}
			${SetEnvironmentVariablesPath} CustomFullPath "$EXEDIR\App\PeerBlock\Modern32"
		${Else}
			${SetEnvironmentVariablesPath} CustomFullPath "$EXEDIR\App\PeerBlock\Legacy32"
		${EndIf}
    ${EndIf}
!macroend

${SegmentPrePrimary}
	ReadINIStr $0 "$EXEDIR\Data\settings\PeerBlockPortableSettings.ini" "PeerBlockPortableSettings" "FirstPlusRunDone"
	${If} $0 != true
		ClearErrors
		MessageBox MB_ICONINFORMATION|MB_OK "PeerBlock Plus Changes$\r$\n$\r$\nPeerBlock's base list provider, iBlockList, limits list updates for free users to once per week. More frequent updates are available with a paid subscription.$\r$\n$\r$\nPeerBlock Plus Portable adds a freely sourced combined blocklist that is automatically updated daily when starting the app.$\r$\n$\r$\nIf you upgraded from PeerBlock Portable before it added this feature, you can enable it be resetting your settings. Close PeerBlock Plus Portable fully, then delete the contents of the PeerBlockPortable\Data directory."
		WriteINIStr "$EXEDIR\Data\settings\PeerBlockPortableSettings.ini" "PeerBlockPortableSettings" "FirstPlusRunDone" "true"
	${EndIf}

	${registry::KeyExists} "HKLM\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_IPFILTERDRIVER" $R0
	${If} $R0 = 0
		StrCpy $Exists_LEGACY_IPFILTERDRIVER true
	${EndIf}
	
	${registry::KeyExists} "HKLM\SYSTEM\CurrentControlSet\Services\IpFilterDriver\Enum" $R0
	${If} $R0 = 0
		StrCpy $Exists_Services_IPFILTERDRIVER true
	${EndIf}
	
	${IfNot} ${AtLeastWinVista}
		${WordReplace} $ExecString "App\PeerBlock\Modern" "App\PeerBlock\Legacy" "+" $ExecString
	${EndIf}
	
	${If} ${FileExists} "$EXEDIR\Data\CustomLists\CustomCombined\*.*"
		ReadINIStr $strCustomLastUpdateDate "$EXEDIR\Data\settings\PeerBlockPortableSettings.ini" "PeerBlockPortableUpdate" "LastUpdateDate"
		
		${GetTime} "" "L" $0 $1 $2 $3 $4 $5 $6
		StrCpy $strCustomCurrentDate "$2-$1-$0"
		
		${If} $strCustomLastUpdateDate != $strCustomCurrentDate
		${OrIfNot} ${FileExists} "$EXEDIR\Data\CustomLists\CustomCombined\blocklist.p2p"
			Delete "$EXEDIR\Data\CustomLists\CustomCombined\blocklist.p2p.gz"
			
			ExecWait `"$EXEDIR\App\Updater\PeerBlockPortablePlusUpdater.exe" /OUTPUT="$EXEDIR\Data\CustomLists\CustomCombined\blocklist.p2p.gz"`
			
			${IfNot} ${FileExists} "$EXEDIR\Data\CustomLists\CustomCombined\blocklist.p2p.gz"
				MessageBox MB_OK|MB_ICONEXCLAMATION `Unable to download blocklist update. Please see help.html for details.`
			${Else} ;Download was ok, check the file
				Delete ${UPDATE_FILE_INI}
				nsExec::Exec `"$EXEDIR\App\Updater\7za.exe" x "$EXEDIR\Data\CustomLists\CustomCombined\blocklist.p2p.gz" -o"$EXEDIR\Data\CustomLists\CustomCombined" -aoa`
				${IfNot} ${FileExists} "$EXEDIR\Data\CustomLists\CustomCombined\blocklist.p2p"
					MessageBox MB_OK|MB_ICONEXCLAMATION `Unable to extract download blocklist. Please see help.html for details.`
				${Else}
					Rename "$EXEDIR\Data\CustomLists\CustomCombined\CustomCombinedBlocklist.p2p" "$EXEDIR\Data\CustomLists\CustomCombined\CustomCombinedBlocklist-old.p2p"
					Rename "$EXEDIR\Data\CustomLists\CustomCombined\blocklist.p2p" "$EXEDIR\Data\CustomLists\CustomCombined\CustomCombinedBlocklist.p2p"
					${IfNot} ${FileExists} "$EXEDIR\Data\CustomLists\CustomCombined\CustomCombinedBlocklist.p2p"
						MessageBox MB_OK|MB_ICONEXCLAMATION `Unable to place updated blocklist. Old blocklist has been restored. Please see help.html for details.`
						Rename "$EXEDIR\Data\CustomLists\CustomCombined\CustomCombinedBlocklist-old.p2p" "$EXEDIR\Data\CustomLists\CustomCombined\CustomCombinedBlocklist.p2p"
					${Else}
						WriteINIStr "$EXEDIR\Data\settings\PeerBlockPortableSettings.ini" "PeerBlockPortableUpdate" "LastUpdateDate" $strCustomCurrentDate
						Delete "$EXEDIR\Data\CustomLists\CustomCombined\CustomCombinedBlocklist-old.p2p"
					${EndIf}
				${EndIf}
			${EndIf}
			Delete "$EXEDIR\Data\CustomLists\CustomCombined\blocklist.p2p.gz"
			Delete "$EXEDIR\Data\CustomLists\CustomCombined\blocklist.p2p"
		${EndIf}
	${EndIf}
!macroend

${SegmentPostPrimary}	
	${IfNot} $Exists_LEGACY_IPFILTERDRIVER == true
		${registry::KeyExists} "HKLM\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_IPFILTERDRIVER" $R0
		${If} $R0 = 0
			AccessControl::GrantOnRegKey HKLM "SYSTEM\CurrentControlSet\Enum\Root\LEGACY_IPFILTERDRIVER" "(BU)" "FullAccess"
			Pop $R0
			${If} $R0 == error
				Pop $R0
				;MessageBox MB_OK|MB_SETFOREGROUND|MB_ICONINFORMATION `AccessControl error: $R0`
			${Else}
				${registry::DeleteKey} "HKLM\SYSTEM\CurrentControlSet\Enum\Root\LEGACY_IPFILTERDRIVER" $R0
			${EndIf}
		${EndIf}
	${EndIf}
	
	${IfNot} $Exists_Services_IPFILTERDRIVER == true
		${registry::KeyExists} "HKLM\SYSTEM\CurrentControlSet\Services\IpFilterDriver" $R0
		${If} $R0 = 0
			AccessControl::GrantOnRegKey HKLM "SYSTEM\CurrentControlSet\Services\IpFilterDriver\Enum" "(BU)" "FullAccess"
			Pop $R0
			${If} $R0 == error
				Pop $R0
				;MessageBox MB_OK|MB_SETFOREGROUND|MB_ICONINFORMATION `AccessControl error: $R0`
			${Else}
				${registry::DeleteKey} "HKLM\SYSTEM\CurrentControlSet\Services\IpFilterDriver\Enum" $R0
			${EndIf}
		${EndIf}
	${EndIf}
!macroend